/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class GTreeView
extends Panel
implements ItemSelectable {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public static final int NODE_TOGGLED = 2001;
    public static final int NODE_EXPANDED = 2002;
    public static final int NODE_COLLAPSED = 2003;
    private Color fontColor = Color.black;
    private Color lineColor = Color.black;
    private Color hilightFontColor = Color.black;
    private Color backgroundColor = Color.black;
    int sbVPosition;
    int sbVWidth;
    int sbHPosition;
    int sbHHeight;
    int cellSize = 20;
    int clickSize = 10;
    int imageInset = 3;
    int textInset = 6;
    int textBaseLine = 3;
    int doubleClickResolution = 333;
    protected GTreeNode rootNode;
    protected GTreeNode selectedNode;
    protected GTreeNode topVisibleNode;
    protected Scrollbar verticalScrollBar = new Scrollbar(1);
    protected boolean sbVShow = false;
    protected int count;
    protected int viewCount;
    protected Scrollbar horizontalScrollBar;
    protected int sbHSize;
    protected int newWidth;
    protected boolean sbHShow = false;
    protected boolean needResetVector;
    protected int sbHLineIncrement = 4;
    protected int viewHeight = 300;
    protected int viewWidth = 300;
    protected int viewWidest;
    protected Key key;
    protected Mouse mouse;
    protected Adjustment adjustment;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected Focus focus;
    protected Vector v;
    protected Vector e;
    protected transient boolean redrawTriggered = false;
    transient boolean hasFocus = false;
    protected transient FontMetrics fm;
    transient long timeMouseDown;
    protected transient Image im1;
    protected transient Graphics g1;
    protected static boolean isSun1_1;
    protected transient ResourceBundle errors;

    static {
        String string = System.getProperty("java.vendor");
        String string2 = System.getProperty("java.version");
        isSun1_1 = !(!string.startsWith("Sun Microsystems Inc.") && !string.startsWith("Apple") || !string2.startsWith("11") && !string2.startsWith("1.1"));
    }

    public GTreeView() {
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new Scrollbar(0);
        this.add(this.horizontalScrollBar);
        this.needResetVector = true;
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
    }

    void GTreeView_MouseClicked(MouseEvent mouseEvent) {
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void addChild(GTreeNode gTreeNode, GTreeNode gTreeNode2) {
        if (gTreeNode2.child == null) {
            gTreeNode2.child = gTreeNode;
            gTreeNode.parent = gTreeNode2;
            ++this.count;
            this.redrawTriggered = true;
        } else {
            this.addSibling(gTreeNode, gTreeNode2.child, true);
        }
        ++gTreeNode2.numberOfChildren;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.verticalScrollBar.addAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.addAdjustmentListener(this.adjustment);
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
    }

    public void addSibling(GTreeNode gTreeNode, GTreeNode gTreeNode2) {
        this.addSibling(gTreeNode, gTreeNode2, true);
    }

    public void addSibling(GTreeNode gTreeNode, GTreeNode gTreeNode2, boolean bl) {
        if (bl) {
            GTreeNode gTreeNode3 = gTreeNode2;
            while (gTreeNode3.sibling != null) {
                gTreeNode3 = gTreeNode3.sibling;
            }
            gTreeNode3.sibling = gTreeNode;
        } else {
            gTreeNode.sibling = gTreeNode2.sibling;
            gTreeNode2.sibling = gTreeNode;
        }
        gTreeNode.parent = gTreeNode2.parent;
        ++this.count;
        this.redrawTriggered = true;
    }

    public void append(GTreeNode gTreeNode) {
        if (this.rootNode == null) {
            this.selectedNode = this.rootNode = gTreeNode;
            this.count = 1;
            this.redrawTriggered = true;
            return;
        }
        this.recount();
        if (this.e.contains(gTreeNode)) {
            System.err.println(new InvalidGTreeNodeException("append: " + this.errors.getString("NodeAlreadyExists")));
            return;
        }
        this.addSibling(gTreeNode, this.rootNode, true);
    }

    protected void changeSelection(GTreeNode gTreeNode) {
        GTreeNode gTreeNode2 = this.selectedNode;
        this.selectedNode = gTreeNode;
        this.drawNodeText(gTreeNode2, (this.v.indexOf(gTreeNode2) - this.sbVPosition) * this.cellSize, true);
        this.drawNodeText(gTreeNode, (this.v.indexOf(gTreeNode) - this.sbVPosition) * this.cellSize, true);
        int n = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, gTreeNode2, 2));
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (n < this.sbVPosition) {
            --this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (n >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.repaint();
    }

    protected int compWidth(Graphics graphics) {
        int n = 0;
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Serif", 0, 13);
            if (graphics != null) {
                graphics.setFont(font);
            }
            this.setFont(font);
        }
        this.fm = graphics == null ? null : graphics.getFontMetrics();
        if (this.fm == null) {
            this.fm = this.getFontMetrics(font);
        }
        if (this.fm == null || this.v == null) {
            n = 100;
        } else {
            int n2 = 0;
            while (n2 < this.v.size()) {
                GTreeNode gTreeNode = (GTreeNode)this.v.elementAt(n2);
                int n3 = (gTreeNode.depth + 1) * this.cellSize + this.cellSize + this.textInset - 12;
                if (n < n3 + this.fm.stringWidth(gTreeNode.text) + 6) {
                    n = n3 + this.fm.stringWidth(gTreeNode.text) + 6;
                }
                ++n2;
            }
        }
        return n;
    }

    protected void drawDotLine(int n, int n2, int n3, int n4) {
        this.g1.drawLine(n, n2, n3, n4);
    }

    protected void drawNodeText(GTreeNode gTreeNode, int n, boolean bl) {
        Color color;
        if (gTreeNode == null) {
            return;
        }
        int n2 = gTreeNode.depth;
        int n3 = (n2 + 1) * this.cellSize + this.cellSize + this.textInset - 12;
        if (gTreeNode == this.selectedNode && this.hasFocus) {
            color = this.getBackground();
            Color color2 = this.hilightFontColor;
        } else {
            Color color3 = this.getForeground();
            color = this.getBackground();
        }
        if (bl) {
            this.g1.setColor(color);
            this.g1.fillRect(n3 - 1, n + 1, this.fm.stringWidth(gTreeNode.text) + 4, this.cellSize - 1);
        }
        if (gTreeNode == this.selectedNode) {
            this.g1.setColor(this.getBackground());
            this.g1.drawRect(n3 - 1, n + 1, this.fm.stringWidth(gTreeNode.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, n3 - 1 - this.sbHPosition), n + 1, this.fm.stringWidth(gTreeNode.text) + 4, this.cellSize - 1);
        }
        if (gTreeNode == this.selectedNode) {
            this.g1.setColor(this.hilightFontColor);
        } else {
            this.g1.setColor(this.fontColor);
        }
        this.g1.drawString(gTreeNode.text, n3, n + this.cellSize - this.textBaseLine);
    }

    protected void drawNodeToggle(GTreeNode gTreeNode, int n, int n2) {
        if (gTreeNode.isExpandable()) {
            this.g1.setColor(this.getBackground());
            this.g1.fillRect(this.cellSize * gTreeNode.depth + this.cellSize / 4, n2 + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.setColor(this.lineColor);
            this.g1.drawRect(this.cellSize * gTreeNode.depth + this.cellSize / 4, n2 + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.drawLine(this.cellSize * gTreeNode.depth + this.cellSize / 4 + 2, n2 + this.cellSize / 2, this.cellSize * gTreeNode.depth + this.cellSize / 4 + this.clickSize - 2, n2 + this.cellSize / 2);
            if (!gTreeNode.isExpanded()) {
                this.g1.drawLine(this.cellSize * gTreeNode.depth + this.cellSize / 2, n2 + this.clickSize / 2 + 2, this.cellSize * gTreeNode.depth + this.cellSize / 2, n2 + this.clickSize / 2 + this.clickSize - 2);
            }
        }
    }

    public void drawTree() {
        Font font;
        Dimension dimension = this.getSize();
        if (this.needResetVector) {
            this.resetVector();
        }
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.g1 == null || this.sbHSize != this.newWidth) {
            this.sbHSize = this.newWidth;
            this.im1 = this.createImage(Math.max(this.sbHSize, dimension.width), dimension.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
        }
        if ((font = this.getFont()) == null) {
            font = new Font("Serif", 0, 13);
            this.g1.setFont(font);
            this.setFont(font);
        }
        if (this.g1.getFont() == null) {
            this.g1.setFont(font);
        }
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.im1.getWidth(this), dimension.height);
        int n = this.sbVPosition + this.viewHeight / this.cellSize + 1;
        if (n > this.viewCount) {
            n = this.viewCount;
        }
        GTreeNode gTreeNode = null;
        if (!this.v.isEmpty()) {
            gTreeNode = (GTreeNode)this.v.elementAt(this.sbVPosition);
        }
        int n2 = this.sbVPosition;
        while (n2 < n) {
            int n3;
            GTreeNode gTreeNode2 = (GTreeNode)this.v.elementAt(n2);
            int n4 = this.cellSize * (gTreeNode2.depth + 1);
            int n5 = (n2 - this.sbVPosition) * this.cellSize;
            this.g1.setColor(this.lineColor);
            if (gTreeNode2.sibling != null) {
                n3 = this.v.indexOf(gTreeNode2.sibling) - n2;
                if (n3 > n) {
                    n3 = n;
                }
                this.drawDotLine(n4 - this.cellSize / 2, n5 + this.cellSize / 2, n4 - this.cellSize / 2, n5 + this.cellSize / 2 + n3 * this.cellSize);
            }
            n3 = 0;
            while (n3 < n2) {
                GTreeNode gTreeNode3 = (GTreeNode)this.v.elementAt(n3);
                if (gTreeNode3.sibling == gTreeNode2 && n3 < this.sbVPosition) {
                    this.drawDotLine(n4 - this.cellSize / 2, 0, n4 - this.cellSize / 2, n5 + this.cellSize / 2);
                }
                ++n3;
            }
            if (gTreeNode2.isExpanded()) {
                this.drawDotLine(n4 + this.cellSize / 2, n5 + this.cellSize - 2, n4 + this.cellSize / 2, n5 + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(this.lineColor);
            this.drawDotLine(n4 - this.cellSize / 2, n5 + this.cellSize / 2, n4 + this.cellSize / 2, n5 + this.cellSize / 2);
            this.drawNodeToggle(gTreeNode2, n4, n5);
            if (gTreeNode2.text != null) {
                this.drawNodeText(gTreeNode2, n5, gTreeNode2 == this.selectedNode);
            }
            if (gTreeNode.depth > gTreeNode2.depth) {
                gTreeNode = gTreeNode2;
            }
            ++n2;
        }
        this.g1.setColor(this.lineColor);
        if (gTreeNode != null) {
            while ((gTreeNode = gTreeNode.parent) != null) {
                if (gTreeNode.sibling == null) continue;
                this.drawDotLine(this.cellSize * (gTreeNode.depth + 1) - this.cellSize / 2, 0, this.cellSize * (gTreeNode.depth + 1) - this.cellSize / 2, dimension.height);
            }
        }
        this.needResetVector = true;
    }

    public boolean exists(GTreeNode gTreeNode) {
        this.recount();
        int n = 0;
        while (n < this.count) {
            if (gTreeNode == this.e.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public synchronized Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public GTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public Object[] getSelectedObjects() {
        if (this.selectedNode == null) {
            return null;
        }
        Object[] objectArray = new GTreeNode[]{this.selectedNode};
        return objectArray;
    }

    protected void handleAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.verticalScrollBar) {
            if (this.sbVPosition != this.verticalScrollBar.getValue()) {
                this.sbVPosition = this.verticalScrollBar.getValue();
                this.triggerRedraw();
                return;
            }
        } else if (adjustmentEvent.getAdjustable() == this.horizontalScrollBar && this.sbHPosition != this.horizontalScrollBar.getValue()) {
            this.sbHPosition = this.horizontalScrollBar.getValue();
            this.triggerRedraw();
        }
    }

    protected void handleFocusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true);
        }
    }

    protected void handleFocusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true);
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        int n = this.v.indexOf(this.selectedNode);
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 13: {
                this.sendActionEvent();
                this.requestFocus();
                return;
            }
            case 37: {
                if (keyEvent.isControlDown()) {
                    if (this.sbHPosition <= 0) break;
                    this.horizontalScrollBar.setValue(Math.max(this.sbHPosition -= this.sbHLineIncrement, 0));
                    this.repaint();
                    return;
                }
                if (this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.itemListener.itemStateChanged(new ItemEvent(this, 2001, this.selectedNode, this.selectedNode.isExpanded ? 2002 : 2003));
                    this.triggerRedraw();
                    return;
                }
            }
            case 38: {
                if (n <= 0) break;
                this.changeSelection((GTreeNode)this.v.elementAt(--n));
                this.requestFocus();
                return;
            }
            case 39: {
                if (keyEvent.isControlDown()) {
                    int n2 = this.horizontalScrollBar.getMaximum() - (isSun1_1 ? this.getSize().width - this.sbVWidth : 0);
                    if (!this.sbHShow || this.sbHPosition >= n2) break;
                    this.horizontalScrollBar.setValue(Math.min(this.sbHPosition += this.sbHLineIncrement, n2));
                    this.repaint();
                    return;
                }
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.sendActionEvent();
                    this.itemListener.itemStateChanged(new ItemEvent(this, 2001, this.selectedNode, this.selectedNode.isExpanded ? 2002 : 2003));
                    this.triggerRedraw();
                    return;
                }
                if (!this.selectedNode.isExpandable()) {
                    return;
                }
            }
            case 40: {
                if (n >= this.viewCount - 1) break;
                this.changeSelection((GTreeNode)this.v.elementAt(++n));
                this.requestFocus();
                return;
            }
        }
    }

    protected void handleMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n2 / this.cellSize + this.sbVPosition;
        if (n3 > this.viewCount - 1) {
            return;
        }
        GTreeNode gTreeNode = this.selectedNode;
        GTreeNode gTreeNode2 = (GTreeNode)this.v.elementAt(n3);
        int n4 = gTreeNode2.getDepth();
        Rectangle rectangle = new Rectangle(this.cellSize * n4 + this.cellSize / 4, (n3 - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (rectangle.contains(n, n2)) {
            gTreeNode2.toggle();
            this.resetVector();
            if (!gTreeNode2.isExpanded() && !this.v.contains(this.selectedNode)) {
                this.changeSelection(gTreeNode2);
            }
            this.triggerRedraw();
            this.invalidate();
            this.sendActionEvent();
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 2001, gTreeNode2, gTreeNode2.isExpanded ? 2002 : 2003));
                return;
            }
        } else {
            this.changeSelection(gTreeNode2);
            mouseEvent.getWhen();
            if (gTreeNode2 == gTreeNode && mouseEvent.getWhen() - this.timeMouseDown < (long)this.doubleClickResolution) {
                gTreeNode2.toggle();
                this.resetVector();
                this.triggerRedraw();
                this.invalidate();
                this.sendActionEvent();
                this.itemListener.itemStateChanged(new ItemEvent(this, 2001, gTreeNode2, gTreeNode2.isExpanded ? 2002 : 2003));
                return;
            }
            this.timeMouseDown = mouseEvent.getWhen();
        }
    }

    protected void handleMouseReleased(MouseEvent mouseEvent) {
    }

    public void insert(GTreeNode gTreeNode, GTreeNode gTreeNode2, int n) {
        if (gTreeNode == null || gTreeNode2 == null) {
            return;
        }
        if (!this.exists(gTreeNode2)) {
            return;
        }
        switch (n) {
            case 0: {
                this.addChild(gTreeNode, gTreeNode2);
                return;
            }
            case 1: {
                this.addSibling(gTreeNode, gTreeNode2, false);
                return;
            }
            case 2: {
                this.addSibling(gTreeNode, gTreeNode2, true);
                return;
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected GTreeNode newGTreeNode(String string) {
        return new GTreeNode(string);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.redrawTriggered || dimension.width != this.viewWidth || dimension.height != this.viewHeight) {
            this.redraw(graphics);
        }
        graphics.translate(-this.sbHPosition, 0);
        graphics.clearRect(this.sbHPosition, 0, dimension.width - this.sbVWidth, dimension.height - this.sbHHeight);
        if (this.sbVShow && this.sbHShow) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(this.sbHPosition + dimension.width - this.sbVWidth, dimension.height - this.sbHHeight, this.sbVWidth, this.sbHHeight);
        }
        graphics.clipRect(this.sbHPosition, 0, dimension.width - this.sbVWidth, dimension.height - this.sbHHeight);
        graphics.drawImage(this.im1, 0, 0, this);
        graphics.setColor(this.backgroundColor);
        graphics.drawRect(this.sbHPosition, 0, dimension.width - this.sbVWidth - 1, dimension.height - this.sbHHeight - 1);
    }

    protected void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    public void redraw() {
        this.triggerRedraw();
    }

    public void redraw(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.redrawTriggered = false;
        if (this.needResetVector) {
            this.resetVector();
        } else {
            this.needResetVector = true;
        }
        this.newWidth = this.compWidth(graphics);
        int n = (dimension.height - this.sbHHeight) / this.cellSize;
        if (this.viewCount > n) {
            this.sbVShow = true;
            this.sbVWidth = this.verticalScrollBar.getPreferredSize().width;
        } else {
            this.sbVShow = false;
            this.sbVWidth = 0;
            this.sbVPosition = 0;
        }
        if (this.newWidth > dimension.width - this.sbVWidth) {
            this.sbHShow = true;
            this.sbHHeight = this.horizontalScrollBar.getPreferredSize().height;
        } else {
            this.sbHShow = false;
            this.sbHHeight = 0;
            this.sbHPosition = 0;
        }
        this.drawTree();
        if (this.sbVShow) {
            this.verticalScrollBar.setBounds(dimension.width - this.sbVWidth, 0, this.sbVWidth, dimension.height - this.sbHHeight);
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.verticalScrollBar.setVisibleAmount(n);
            this.verticalScrollBar.setMinimum(0);
            this.verticalScrollBar.setMaximum(this.viewCount);
            this.verticalScrollBar.setBlockIncrement(n - 1);
            this.verticalScrollBar.setVisible(true);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        if (this.sbHShow) {
            this.horizontalScrollBar.setBounds(0, dimension.height - this.sbHHeight, dimension.width - this.sbVWidth, this.sbHHeight);
            this.horizontalScrollBar.setValue(this.sbHPosition);
            this.horizontalScrollBar.setVisibleAmount(dimension.width - this.sbVWidth);
            this.horizontalScrollBar.setMinimum(0);
            this.horizontalScrollBar.setMaximum(this.sbHSize);
            this.horizontalScrollBar.setBlockIncrement(dimension.width - this.sbVWidth);
            this.horizontalScrollBar.setUnitIncrement(this.sbHLineIncrement);
            this.horizontalScrollBar.setVisible(true);
            return;
        }
        this.horizontalScrollBar.setVisible(false);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.verticalScrollBar.removeAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    protected void resetVector() {
        this.v = new Vector(this.count);
        this.viewWidest = 30;
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, true, this.v);
        this.viewCount = this.v.size();
        this.needResetVector = false;
    }

    protected void sendActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, new String(this.selectedNode.getText())));
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.backgroundColor = color;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public void setHilightFontColor(Color color) {
        this.hilightFontColor = color;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    protected void traverse(GTreeNode gTreeNode) {
        ++this.count;
        this.e.addElement(gTreeNode);
        if (gTreeNode.child != null) {
            gTreeNode.child.depth = gTreeNode.depth + 1;
            this.traverse(gTreeNode.child);
        }
        if (gTreeNode.sibling != null) {
            gTreeNode.sibling.depth = gTreeNode.depth;
            this.traverse(gTreeNode.sibling);
        }
    }

    public void triggerRedraw() {
        this.redrawTriggered = true;
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void vectorize(GTreeNode gTreeNode, boolean bl, Vector vector) {
        if (gTreeNode == null) {
            return;
        }
        vector.addElement(gTreeNode);
        if (!bl && gTreeNode.child != null || gTreeNode.isExpanded()) {
            gTreeNode.child.depth = gTreeNode.depth + 1;
            this.vectorize(gTreeNode.child, bl, vector);
        }
        if (gTreeNode.sibling != null) {
            gTreeNode.sibling.depth = gTreeNode.depth;
            this.vectorize(gTreeNode.sibling, bl, vector);
        }
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        Adjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            GTreeView.this.handleAdjustmentEvent(adjustmentEvent);
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        Mouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GTreeView.this.handleMousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            GTreeView.this.handleMouseReleased(mouseEvent);
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        Key() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            GTreeView.this.handleKeyPressed(keyEvent);
        }
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        Focus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            GTreeView.this.handleFocusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            GTreeView.this.handleFocusLost(focusEvent);
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == GTreeView.this) {
                GTreeView.this.GTreeView_MouseClicked(mouseEvent);
            }
        }
    }
}

