/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.util.Vector;

class DoctorPanel
extends Panel {
    Doctor app;
    String system;
    int port;
    Socket sock;
    DataInputStream sin;
    PrintStream sout;
    String appletType;
    String dataScript;
    String dbName;
    String dbTable;
    String dbColumns;
    String dbPeriod;
    String dbFilterColumn;
    String dbFilterValue;
    String auth;
    Display display;
    Scroller scroller;
    Image uw;
    Graphics ug;
    Graphics lastug;
    Point last = new Point(0, 0);
    boolean resize = false;
    boolean hit = false;
    boolean cornerhit = false;
    boolean scrollhit = false;
    boolean offscreen = true;

    public DoctorPanel(Doctor doctor) {
        this.setBackground(Color.lightGray);
        this.app = doctor;
        SymContainer symContainer = new SymContainer();
        this.addContainerListener(symContainer);
    }

    public void init() {
        this.auth = this.app.getParameter("authorization");
        this.dataScript = this.app.getParameter("dataScript");
        this.system = this.app.getParameter("system");
        this.port = Integer.parseInt(this.app.getParameter("port"));
        if (this.dataScript == null || this.system == null) {
            System.out.println("dataScript and system are both null");
            return;
        }
        this.dbName = this.app.getParameter("database");
        this.dbTable = this.app.getParameter("table");
        this.dbColumns = this.app.getParameter("columns");
        this.dbPeriod = this.app.getParameter("period");
        if (this.dbName == null) {
            this.dbName = "primary";
        }
        if (this.dbTable == null) {
            System.out.println("Must specify table name.");
            return;
        }
        if (this.dbColumns == null) {
            this.dbName = "*";
        }
        if (this.dbPeriod == null) {
            this.dbPeriod = "5";
        }
        this.dbFilterColumn = this.app.getParameter("filterColumn");
        this.dbFilterValue = this.app.getParameter("filterValue");
        this.appletType = this.app.getParameter("appletType");
        if (this.appletType == null) {
            this.appletType = "barGraph";
            return;
        }
        if (this.appletType.equals("barGraph")) {
            this.display = new BarGraph(this);
        } else if (this.appletType.equals("timeGraph")) {
            this.display = new TimeGraph(this);
        } else {
            return;
        }
        this.fetchData(false);
        this.scroller = new Scroller(this);
        Utility utility = this.app.utility;
        int n = utility.readInteger(300, "width");
        int n2 = utility.readInteger(300, "height");
        this.scroller.init(0, 0, n, n2);
        this.setBounds(this.scroller.b);
        this.display.setScroller(this.scroller);
        this.scroller.setGraph(this.display);
        this.display.invalidate();
        this.paint(this.getGraphics());
    }

    public void closeSocket() {
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {}
        this.sock = null;
    }

    public void fetchData(boolean bl) {
        Vector<String> vector = null;
        URL uRL = this.app.getDocumentBase();
        String string = uRL.getHost();
        int n = this.port;
        System.out.println(string);
        System.out.println(n);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkAccept(string, n);
            }
            catch (SecurityException securityException) {
                System.out.println("security.checkAccept failed in check data\r\n");
            }
        }
        try {
            try {
                if (this.sock == null) {
                    System.out.println("About to open socket\r\n");
                    this.sock = new Socket(string, n);
                    System.out.println("Socket opened\r\n");
                    this.sin = new DataInputStream(this.sock.getInputStream());
                    this.sout = new PrintStream(this.sock.getOutputStream());
                }
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append("GET " + this.dataScript);
                stringBuffer.append("?database=" + this.dbName);
                stringBuffer.append("&table=" + this.dbTable);
                stringBuffer.append("&columns=" + this.dbColumns);
                stringBuffer.append("&period=" + this.dbPeriod);
                if (this.dbFilterColumn != null && this.dbFilterValue != null) {
                    stringBuffer.append("&filtercolumn=" + this.dbFilterColumn);
                    stringBuffer.append("&filtervalue=" + this.dbFilterValue);
                }
                stringBuffer.append(" HTTP/1.0\n");
                stringBuffer.append("User-Agent: Go-Ahead-Doctor/1.0\n");
                stringBuffer.append("authorization: " + this.auth + "\n");
                this.sout.println(stringBuffer.toString());
                vector = new Vector<String>();
                try {
                    String string2;
                    while ((string2 = this.sin.readLine()) != null) {
                        if (string2.length() <= 0) continue;
                        vector.addElement(string2);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {}
        this.sock = null;
        if (vector.size() > 0) {
            this.display.readData(vector);
            if (bl) {
                this.paint(this.getGraphics());
            }
        }
    }

    public void update(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            graphics = this.getGraphics();
        }
        if (graphics == null) {
            return;
        }
        this.drawOffScreen(graphics);
        if (this.uw != null) {
            graphics.drawImage(this.uw, 0, 0, this);
        }
    }

    public void drawOffScreen(Graphics graphics) {
        if (this.uw == null) {
            this.uw = this.createImage(this.bounds().width, this.bounds().height);
        }
        if (this.uw != null) {
            this.ug = this.uw.getGraphics();
        }
        if (this.ug == null) {
            return;
        }
        this.scroller.draw(this.ug);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 501: {
                if (event.modifiers == 4) {
                    this.paintAll(this.getGraphics());
                } else if (this.scroller.scrollBarHit(event.x, event.y)) {
                    this.scrollhit = true;
                } else if (this.scroller.incrementHit(event.x, event.y)) {
                    this.hit = true;
                } else if (this.scroller.decrementHit(event.x, event.y)) {
                    this.hit = true;
                } else if (this.scroller.scrollHit(event.x, event.y)) {
                    this.hit = true;
                } else if (this.scroller.mouseHit(event.x, event.y)) {
                    this.hit = true;
                }
                if (this.hit) {
                    this.display.invalidate();
                    this.paint(this.getGraphics());
                }
                this.last.x = event.x;
                this.last.y = event.y;
                return true;
            }
            case 502: {
                this.paint(this.getGraphics());
                this.scrollhit = false;
                this.cornerhit = false;
                this.hit = false;
                return true;
            }
            case 506: {
                if (this.scrollhit) {
                    this.scroller.scrollBy(event.x - this.last.x, event.y - this.last.y);
                }
                this.last.x = event.x;
                this.last.y = event.y;
                this.paint(this.getGraphics());
                this.getToolkit().sync();
                return true;
            }
            case 201: {
                return true;
            }
        }
        return false;
    }

    void DoctorPanel_ComponentAdded(ContainerEvent containerEvent) {
    }

    class SymContainer
    extends ContainerAdapter {
        public void componentAdded(ContainerEvent containerEvent) {
            Object object = containerEvent.getSource();
            if (object == DoctorPanel.this) {
                DoctorPanel.this.DoctorPanel_ComponentAdded(containerEvent);
            }
        }

        SymContainer() {
            DoctorPanel.this = DoctorPanel.this;
        }
    }
}

